/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.openrap.gwtplugindetect.client.getversion;

/**
 *
 * @author richard
 */
public class PluginDetectGetVersion {

  /**
   * Retrieves the version of the active JRE, if any.
   *
   * @return an array containing the major and minor version numbers
   */
  public static int[] getJavaVersion() {
    String jre = detectJavaVersion();
    if (jre == null || jre.equals("")) {
      return new int[]{0, 0, 0, 0};
    }
    String[] jreVersions = jre.split(",");
    if (jreVersions.length != 4) {
      return new int[]{0, 0, 0, 0};
    }
    try {
      return new int[]{
        new Integer(jreVersions[0]).intValue(),
        new Integer(jreVersions[1]).intValue(),
        new Integer(jreVersions[2]).intValue(),
        new Integer(jreVersions[3]).intValue()
      };
    } catch (Exception x) {
    }
    return new int[]{0, 0, 0, 0};
  }

  /**
   * A native wrapper to a JavaScript function which detects the version of the active JRE, if any.
   *
   * @return a string containing the major and minor version numbers, comma delimited
   */
  private native static String detectJavaVersion()/*-{
   return $wnd.PluginDetect.getVersion('Java') || '0,0,0,0';
   }-*/;
}
